/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betterstrongholds.world.processor;

import com.mojang.serialization.Codec;
import com.yungnickyoung.minecraft.betterstrongholds.BetterStrongholds;
import com.yungnickyoung.minecraft.betterstrongholds.init.BSModProcessors;
import com.yungnickyoung.minecraft.betterstrongholds.world.ArmorStandChances;
import java.util.Random;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.gen.feature.template.IStructureProcessorType;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.Template;

@MethodsReturnNonnullByDefault
public class ArmorStandProcessor
extends StructureProcessor {
    public static final ArmorStandProcessor INSTANCE = new ArmorStandProcessor();
    public static final Codec<ArmorStandProcessor> CODEC = Codec.unit(() -> INSTANCE);

    @ParametersAreNonnullByDefault
    public Template.EntityInfo processEntity(IWorldReader world, BlockPos seedPos, Template.EntityInfo localEntityInfo, Template.EntityInfo globalEntityInfo, PlacementSettings placementSettings, Template template) {
        if (globalEntityInfo.field_186249_c.func_74779_i("id").equals("minecraft:armor_stand")) {
            String helmet;
            ListNBT armorItems = globalEntityInfo.field_186249_c.func_150295_c("ArmorItems", 10);
            Random random = placementSettings.func_189947_a(globalEntityInfo.field_186248_b);
            try {
                helmet = ((CompoundNBT)armorItems.get(3)).func_74781_a("id").toString();
            }
            catch (Exception e) {
                BetterStrongholds.LOGGER.info("Unable to randmize armor stand at {}. Missing helmet?", (Object)globalEntityInfo.field_186248_b);
                return globalEntityInfo;
            }
            boolean isRare = false;
            if (helmet.equals("\"minecraft:diamond_helmet\"")) {
                isRare = true;
            }
            CompoundNBT newNBT = globalEntityInfo.field_186249_c.func_74737_b();
            String bootsString = isRare ? ArmorStandChances.get().getRareBoots(random).getRegistryName().toString() : ArmorStandChances.get().getCommonBoots(random).getRegistryName().toString();
            ((CompoundNBT)newNBT.func_150295_c("ArmorItems", 10).get(0)).func_74778_a("id", bootsString);
            ((CompoundNBT)newNBT.func_150295_c("ArmorItems", 10).get(0)).func_74774_a("Count", (byte)1);
            CompoundNBT bootsTagNBT = new CompoundNBT();
            bootsTagNBT.func_74768_a("Damage", 0);
            ((CompoundNBT)newNBT.func_150295_c("ArmorItems", 10).get(0)).func_218657_a("tag", (INBT)bootsTagNBT);
            String leggingsString = isRare ? ArmorStandChances.get().getRareLeggings(random).getRegistryName().toString() : ArmorStandChances.get().getCommonLeggings(random).getRegistryName().toString();
            ((CompoundNBT)newNBT.func_150295_c("ArmorItems", 10).get(1)).func_74778_a("id", leggingsString);
            ((CompoundNBT)newNBT.func_150295_c("ArmorItems", 10).get(1)).func_74774_a("Count", (byte)1);
            CompoundNBT leggingsTagNBT = new CompoundNBT();
            leggingsTagNBT.func_74768_a("Damage", 0);
            ((CompoundNBT)newNBT.func_150295_c("ArmorItems", 10).get(1)).func_218657_a("tag", (INBT)leggingsTagNBT);
            String chesplateString = isRare ? ArmorStandChances.get().getRareChestplate(random).getRegistryName().toString() : ArmorStandChances.get().getCommonChestplate(random).getRegistryName().toString();
            ((CompoundNBT)newNBT.func_150295_c("ArmorItems", 10).get(2)).func_74778_a("id", chesplateString);
            ((CompoundNBT)newNBT.func_150295_c("ArmorItems", 10).get(2)).func_74774_a("Count", (byte)1);
            CompoundNBT chestplateTagNBT = new CompoundNBT();
            chestplateTagNBT.func_74768_a("Damage", 0);
            ((CompoundNBT)newNBT.func_150295_c("ArmorItems", 10).get(2)).func_218657_a("tag", (INBT)chestplateTagNBT);
            String helmetString = isRare ? ArmorStandChances.get().getRareHelmet(random).getRegistryName().toString() : ArmorStandChances.get().getCommonHelmet(random).getRegistryName().toString();
            ((CompoundNBT)newNBT.func_150295_c("ArmorItems", 10).get(3)).func_74778_a("id", helmetString);
            ((CompoundNBT)newNBT.func_150295_c("ArmorItems", 10).get(3)).func_74774_a("Count", (byte)1);
            CompoundNBT helmetTagNBT = new CompoundNBT();
            helmetTagNBT.func_74768_a("Damage", 0);
            ((CompoundNBT)newNBT.func_150295_c("ArmorItems", 10).get(3)).func_218657_a("tag", (INBT)helmetTagNBT);
            globalEntityInfo = new Template.EntityInfo(globalEntityInfo.field_186247_a, globalEntityInfo.field_186248_b, newNBT);
        }
        return globalEntityInfo;
    }

    protected IStructureProcessorType<?> func_215192_a() {
        return BSModProcessors.ARMORSTAND_PROCESSOR;
    }
}

